@extends('frontend.layouts.app')
@push('style')
<style>
    .header-style-two {
        background: rgba(40, 60, 71, 0.40);
    }
</style>
@endpush
@section('content')


<section class="contact-form">
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <div class="contact-form-left-container">
                    <div class="contact-form-left-image">
                        <img src="{{asset('frontend/images/contact-us.png')}}" alt="Contact Image">
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="contact-form-right-container">
                    <h3 class="mb_10">@lang('app.get-in-touch')</h3>
                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li class="mb-0">{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    <form action="{{route('contact')}}" method="post">
                        @csrf
                        <div class="row">
                            <div class="col-lg-6 mb-3">
                                <input type="text"
                                       name="name"
                                       class="contact-input"
                                       value="{{ old('name') }}"
                                       placeholder="@lang('app.your') @lang('app.name')">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="email"
                                       name="email"
                                       class="contact-input"
                                       value="{{ old('email') }}"
                                       placeholder="@lang('app.your') @lang('app.email')">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="tel"
                                       name="phone"
                                       class="contact-input"
                                       value="{{ old('phone') }}"
                                       placeholder="@lang('app.your') @lang('app.phone')">
                            </div>
                            <div class="col-lg-6 mb-3">
                                <input type="text"
                                       name="subject"
                                       class="contact-input"
                                       value="{{ old('subject') }}"
                                       placeholder="@lang('app.subject')">
                            </div>
                            <div class="col-lg-12 mb-3">
                                <textarea name="message"
                                          class="contact-input"
                                          placeholder="@lang('app.write-your-message')">{{ old('message') }}</textarea>
                            </div>
                            <div class="col-lg-12 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input contactCur"
                                           name="check"
                                           value="1"
                                           type="checkbox"
                                           id="subscribe"
                                           {{ old('check') ? 'checked' : '' }}>
                                    <label class="form-check-label" for="subscribe">
                                        @lang('app.select-to-subscribe')
                                    </label>
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <button type="submit" class="btn-1 w-100">
                                    @lang('app.submit')
                                    <i class="fas fa-paper-plane ms-2"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="contact-info">
    <div class="container">
        <div class="row">
            <div class="col-xl-3 col-lg-4 col-md-6 offset-xl-1">
                <div class="contact-info-content">
                    <div class="icon">
                        <i class="fa-light fa-location-dot"></i>
                    </div>
                    <div class="content">
                        <h6>16/A,Romadan House City Tower New York,USA</h6>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6">
                <div class="contact-info-content">
                    <div class="icon">
                        <i class="fa-light fa-phone"></i>
                    </div>
                    <div class="content">
                        <a href="tel:{{setting('sitephone')}}">{{setting('sitephone')}}</a>
                    </div>
                </div>
            </div>
            <div class="col-xl-3 col-lg-4 col-md-6">
                <div class="contact-info-content">
                    <div class="icon">
                        <i class="fa-light fa-envelope"></i>
                    </div>
                    <div class="content">
                        <a href="mailto:{{setting('email')}}">{{setting('email')}}</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<section class="contact-map">
    <div class="container">
        <div class="rpw">
            <div class="col-lg-12">
                <div class="destination-details-map">
                    <h5 class="destination-details-common-title">
                        @lang('app.our-location')
                    </h5>
                    <div class="map-container">
                            <iframe class="mapIn" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d4339.963605701106!2d90.37604191636046!3d23.76702410183389!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3755c7543a947b03%3A0xd75e6a88605a6663!2sChandrima%20Udyan!5e0!3m2!1sen!2sbd!4v1737302676312!5m2!1sen!2sbd" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection
